// Global Header file of the CForth C011(SO8) project ************************
//
// Author and (c)2025 Wolfgang Schemmert. The copyright claim is restricted
// to this file and the depending files "main.c", "main.h", "cforth.c" and
// "cforth.h"
// Other depending material is published, copyrighted and licensed
// by STMicroelectronics and Segger GmbH
//
// Contact: <www.midi-and-more.de>
// A detailled hardware construction and operation manual
// is provided at this website
//
// ***************************************************************************
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//	Licence: GPL-3
//
// ***************************************************************************
#ifndef GLOBALDEFINES
#define GLOBALDEFINES

#define REVNUM 1            //describes firmware revision

#define HARDWARE_VERSION 1  //describes project specific SO8 hardware version

#define CLOCK_48M			//else Low-Power version with 3.0 MHz SystemClock
#ifndef CLOCK_48M
  #define CLOCK_3M
#endif

//attributes of KernelOperators
//attribute entries are merged with some other functional flags !!
#define A_IME  0x10000	//ATTRIBUTE_IMMEDIATE, cannot be compiled
#define A_CPO  0x20000	//ATTRIBUTE_COMPILEONLY,refuse work interpreting
#define A_BAK  0x40000	//may be parsed in background at executing state
#define A_CI   (A_CPO | A_IME) //COMPILEONLY IMMEDIATE
						//performs complex operations during compilation
#define A_IB   (A_IME | A_BAK)
#define A_RUN   0x80000 //ATTRIBUTE_RUNTIME,
					//compiled by other operators for special runtime behaviour
					//no direct user access, essential for viewing SEE and STEP
//only attribute of UserToken
#define A_VARCON  0x0C000000

#define ERR_STRINGTOKEN  1
#define ERR_SYNTAX       2
#define ERR_STACK        4
#define ERR_COMPONLY     8
#define ERR_SYSTEM       0x10
#define ERR_USERCODE     0x20
#define ERR_CONTEXT      0x80
#define ERR_USERCONTEXT  0xA0	//combination of both, save code memory
#define ERR_USERSTRING   0x21	//combination of both, save code memory
#define ERR_CANCEL       0x100
#define ERR_RUNTOKEN     0x200
#define ERR_NUMVAL       0x400
#define ERR_DIVZERO      0x800

#define PAGE12  (0x08006000)	//Project1:gfUserToken (headers)	
#define PAGE13  (0x08006800)	//Project1:gfTCode
#define PAGE14  (0x08007000)	//Project2:gfUserToken (headers)
#define PAGE15  (0x08007800)	//Project2:gfTCode

#define KERNELSIZE  126

#define MAXUSER     96//*4 words p.struct=384 words=1536 bytes== 3/4 page
#define MAXCODE     0x800	//2048 bytes =  full page of 2048 bytes

#define MAXDATASTACK    24
#define MAXRETSTACK     24

#define CODETOP         MAXCODE - 1
#define USERTOP         (uint32_t)&gfUserHeader[MAXUSER]

#define USART_RXBUFLEN 900

#define DEFAULT_BAUD   11	//expanded to 115200, 
							//enter first 2 places, e.g. 96 for 9600

#define DEFAULT_NUMBASE 10	//Decimal, enter 16 for HEX

#define CTRL_B  2
#define CTRL_C  3
#define BKSP  8
#define TAB  9
#define LFF  10		//for Macintosh OS: simply exchange values of CRR and LFF
#define CRR  13		//then New_Line will be interpreted correctly
#define CTRL_R  18
#define ESC  27		//0x1B
#define SPACE  32
#define BACKSLASH  92//0x5C

#endif  //GLOBALDEFINES

// ##########################################################################
// Version changes:
//REVNUM 1: evelopment started 16 November2025
//basic code copied from 
//CForthLoPo for STM32L031, REVNUM8(state Apr.25),
//parts used from CForth-LoPo-F030, CForth-LoPo-F042, CForth-LoPo-G4xx

//SeggeremProjct file modified for STM2C011
//CPU specific basic files replaced for STM32c011
//heavy rearrangement of Cortex_M_startup.s to fit for STM32C011
//GPIO pins restricted/rearranged for 8pin processor module (SYSCFG register)

//19Nov25	setSysClock() rearranged to 48 MHz HSI driven SYSCLK
//20Nov25	op_EEPROM, op_SLEEP, op_LED, op_SPEED deleted, op_NRSET new.
//21Nov25	Access to GPIO rearranged for only 4 available pins (1,2,3,4) 
//22Nov25	USART Tx is PA9, USART Rx is Pb7(pin1),
//			subIinitUsart1() removed into initUsart()
//			"ifdef MOTOR" removed, opMOT and op_PWM2 work together
//26Nov25	Flash pages access rearranged for 2 well org. user projects
//27Nov25	msDelay() and wait5us() improved for actual setSysClock()
//28Nov25	Timer1 working now, op_Freq(),op_PWM1(),op_PWM2(),opMOT() fitted
//			emptyForth(),popFlashProject(),pushFlashProject() updated/improved
//29Nov25	research and change of Flash/Option bytes successful
//			NRSET() improved, PA1SET() new, both tested together
//			op_INI-SPI(), op_SPI() rewritten: PA1(SCLK),PA12(MOSI),PA13(MISO)
//			popFlashProject() improved, options "10 SAVE" and "12 SAVE" new
//30Nov25	PA9 = USART Tx available as PA8 user I/O#5 in checkValidIO()
//			opARRAY() deleted, op_TXON() new, counterCheck with 5oh, 5ol etc.
//02Dec25	option CLOCK_3M new, systemCoreClock fitted for 3 and 48MHz SYSCLK
//			RCC_CR_HSIKERDIV now always 48MHz - is USART clock at 3 and 48MHz
//			op_FREQ(),op_PWM1(),op_PWM2() 3MHz-fitted(Freq<=15kHz PWM max 200)
//05Dec25	MAXCODE and stacks depth increased to max.SRAM compatible vaues

// *******************************