// Global Header file of the CForth NucleoF042 project ************************
//
// Author and (c)2020-25 Wolfgang Schemmert. The copyright claim is restricted
// to this file and the depending files "main.c", "main.h", "cforthLP.c" and
// "cforthLP.h"
// Other depending material is published, copyrighted and licensed
// by STMicroelectronics and Segger GmbH
//
// Contact: <www.midi-and-more.de>
// A detailled hardware construction and operation manual
// is provided at this website
//
// ****************************************************************************
//      This program is free software: you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//      Licence: GPL-3
//
// ****************************************************************************

#ifndef GLOBALDEFINES
#define GLOBALDEFINES

#define REVNUM 2            //describes firmware revision

//always LQFP32 hardware

#define HARDWARE_VERSION 2  //describes project specific hardware version
#define USARTIO
//#define EXTCLOCK_8M			//else int.16MHz HSI (recommended default)

// *******************************

//attributes of KernelOperators
//attribute entries are merged with some other functional flags !!
#define A_IME			0x10000 //ATTRIBUTE_IMMEDIATE, cannot be compiled
#define A_CPO			0x20000 //ATTRIBUTE_COMPILEONLY,refuse work interpreting
#define A_BAK			0x40000 //may be parsed in background at executing state
#define A_CI			(A_CPO | A_IME) //COMPILEONLY IMMEDIATE
								//performs complex operations during compilation
#define A_IB			(A_IME | A_BAK)
#define A_RUN			0x80000 //ATTRIBUTE_RUNTIME,
					//compiled by other operators for special runtime behaviour
					//no direct user access, essential for viewing SEE and STEP
//only attribute of UserToken
#define A_VARCON		0x0C000000

#define ERR_STRINGTOKEN 1
#define ERR_SYNTAX		2
#define ERR_STACK		4
#define ERR_COMPONLY	8
#define ERR_SYSTEM		0x10
#define ERR_USERCODE	0x20
#define ERR_COMMACC		0x40
#define ERR_CONTEXT 	0x80
#define ERR_USERCONTEXT	0xA0	//combination of both, save code memory
#define ERR_USERSTRING	0x21	//combination of both, save code memory
#define ERR_CANCEL		0x100
#define ERR_RUNTOKEN	0x200
#define ERR_NUMVAL		0x400
#define ERR_DIVZERO		0x800

//#define PAGE25 (0x08006400)	//globals: only gBaud, gfNumBase and gProject
#define PAGE26 (0x08006800)	//Project1:single word parameters and gfUserToken
#define PAGE27 (0x08006C00)	//Project1:gfUserToken and gfTCode
#define PAGE28 (0x08007000)	//Project1:gfTCode
#define PAGE29 (0x08007400)	//Project2:single word parameters and gfUserToken 
#define PAGE30 (0x08007800)	//Project2:gfUserToken and gfTCode
#define PAGE31 (0x08007C00)	//Project2:gfTCode

#ifdef USARTIO
#define KERNELSIZE		125
#else
#define KERNELSIZE		123
#endif
#define MAXUSER			95//*4 words p.struct=380 words=1520 bytes=ca.1.5pages
#define MAXCODE			0x600	//bytes = 1.5 pages

#define MAXDATASTACK	28
#define MAXRETSTACK		28

#define CODETOP         MAXCODE - 1
#define USERTOP         (uint32_t)&gfUserHeader[MAXUSER]
#ifdef USARTIO
#define RXBUFLEN 512
#define MIDI_BUFLEN 32
#else
#define RXBUFLEN 604
#endif
#define DEFAULT_NUMBASE	10 //Decimal, enter 16 for HEX
#define DEFAULT_BAUD	11

#define CTRL_B  2
#define CTRL_C  3
#define BKSP  8
#define TAB   9
#define LFF  10		//for Macintosh OS: simply exchange values of CRR and LFF
#define CRR  13		//then New_Line will be interpreted correctly
#define CTRL_R  18
#define CTRL_T  20
#define ESC  27
#define SPACE  32
#define BACKSLASH 92
#ifdef USARTIO
#define EOX		0xF7
#endif
#endif  //GLOBALDEFINES

// ##########################################################################

// Version changes:
//REVNUM 1: copied 01Jan25 from code "cforth-lp-F042-REVNUM13", 48MHz version
//			code for other SystemFreq removed.
//			first MSI code developed
//02Jan25	SetSysClock() modes for 16MHz HSI(unmod Nucleo) + 8MHZ STLINK HSE
//			USART2 prepared for STLINK demands, only terminal interface now
//			kernel ops BAUD and SPEED removed (only 48MHz, 115.2kBaud remain)
//			FlashProject() reorg. for that reason
//			kenel op SLEEP removed (doesn't make sense together with STLINK)
//			first completely working firmware
//			due to saved kernel code, ops MOTOR and PWM2 exist simultaneously
//16Jan25	{"REV"} renamed {"W"}, op_REV renamed op_WVA ("write_Variable")
//18Jan25	VARCONs directly stored in user code. op_VALUE unnecessary/removed
//20Jan25	improvement background process gfStepSpeed
//			Bugfix  executeTCode() and op_ABORT, NO_DBG was always cancelled
//30Jan25	AUTOEXE check now PA9 (temporarily pulledUp)
//01Feb25	DEBUG renamed BACKOP, NO_DBG renamed NOBACK
//			CTRL_B->CTRL_C, CTRL_D->CTRL_B
//released 08 Febr 2025
//REVNUM->2
//05March25 "sendModel" now moved to op_QUEST()()
//March2025	heavy redesign with RS232 and MIDI IO via USART, HW ver.2
//04Apr25	optimization of op_LOAD,op_SAVE
//			bugfix op_FORGET, gfAuto improvement, in op_ABORT,too
// *******************************