// main.h Header file of the CForth LowPower project *************************
//
// Author and (c)2020-25 Wolfgang Schemmert. The copyright claim is restricted
// to this file and the depending files "main.c", "cforth.c", "cforth.h"
// and "globaldefines.h"
// Other depending material is published, copyrighted and licensed
// by STMicroelectronics and Segger GmbH
//
// Contact: <www.midi-and-more.de>
// A detailled hardware construction and operation manual
// is provided at this website
//
// ****************************************************************************
//      This program is free software: you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//      Licence: GPL-3
//
// ****************************************************************************

#include "globaldefines.h"

// from cforth.h
extern uint32_t gfMSCOUNT, gfTIXCOUNT;
extern uint32_t gfTibMax;
extern uint32_t gfTermInput;		//message from terminal iput to DEBUG();
extern uint32_t gfBackProcess, gfBackNumValid;
extern uint32_t gfNumBase, gfTempNumBase, gfAuto;
extern uint32_t gfSpiMode, gfSpiBits, gfSpiClock;
extern int32_t gfPWM1, gfPWM2;
extern uint32_t gfFreq;
extern int32_t gfSTEPCOUNT;
extern uint32_t gfRandom;

extern uint32_t gfCompiState;		//0=interpreting, 1=compiling
extern uint32_t gfErrors, gfParsed;
extern uint32_t *gfSP;				//Datastack Pointer
extern uint32_t *gfRP;				//Returnstack Pointer
extern uint32_t *gfIP;				//Instruction Pointer
extern uint8_t gfTCode[];			//1536bytes = 1.5 page

extern struct USERHEADER
{
uint8_t name[16];
uint32_t toCompile;
uint32_t attributes;
} gfUserHeader[MAXUSER];
//4 words = 16 bytes/struct *95 elements=380 words=1520 bytes=ca.1.5pages

extern void quit(void);
extern uint32_t query(void);
extern void eval(void);
extern uint32_t interpretUserToken(void);
extern uint32_t executeTCode(void);
extern void emptyForth(void);
//extern void op_NOP(void);
extern void op_BAKOP(void);
extern void op_ABORT(void);
extern void op_QUEST(void);
extern void subFREQ(void);
extern void subPWM1(void);
extern void subPWM2(void);
extern void op_SPEED(void);

// ****************************************


uint8_t gSTLINK_RXBUF[RXBUFLEN+4];
uint8_t *gSTLINK_RXHEAD=0,*gSTLINK_RXTAIL=0,*gSTLINK_RXBUFTOP= &(gSTLINK_RXBUF[RXBUFLEN]);

//system control
uint32_t gSYSCOUNT, gLEDCOUNT, gDELAYCOUNT, gTIMEOUT;
uint32_t gBaud, gTempBaud, gProject, gLedBusy; // gBaudSet, 
#ifdef USARTIO
uint32_t  gSplit, gTransparent;
#endif

#ifdef USARTIO
uint8_t gUSART_RXBUF[RXBUFLEN+4];
uint8_t *gUSART_RXHEAD=0,*gUSART_RXTAIL=0;
uint8_t *gUSART_RXBUFTOP= &(gUSART_RXBUF[RXBUFLEN]);
uint32_t gMIDIBUF[MIDI_BUFLEN];		//max 32 unprocessed MIDI messages are stored
uint32_t gMIDI_HEAD, gMIDI_TAIL;
uint32_t gSplit, gTransparent, gTransEnd;
#endif

uint32_t SystemCoreClock    = 48000000;
void SetSysClock(void);
void LED_Off(void);
void msDelay(uint32_t);
void wait5us(void);
void servSystem(void);
void startUSB(void);
void popFlashProject(uint32_t);
void postLoad(void);
void pushFlashProject(uint32_t);

//USART

void initUsart2(void);
void sendUsbByte(uint8_t);
#ifdef USARTIO
void initUsart1(void);
#endif
void sendTB(uint8_t);
void sendString(const uint8_t *);
void sendNibble(uint8_t);
void sendX8(uint32_t);
void sendX32(uint32_t);
void sendNX32(uint32_t);
void send0X32(uint32_t);
void sendLS32(uint32_t);
void sendS32(uint32_t);
void sendNS32(uint32_t);
void sendE(float);
uint32_t pullTermRxBuf(void);
uint8_t parseHexNibble(uint8_t);
uint32_t parseHexNum(uint8_t);
uint8_t parseDeciDigit(void);
uint32_t pullUsbRxBuf(void);
#ifdef USARTIO
void initUsart1(void);
void sendUsbByte(uint8_t);
void sendB(uint8_t);
void sendIOB(uint8_t);
uint32_t pullUsartRxBuf(void);
void MidiScanner(uint32_t);
uint32_t pullMidiBuf(void);
#endif
//Interrupt handlers
//void SysTick_Handler(void);
//void USART2_IRQHandler(void);
