// **********************************************************************
// *                    SEGGER Microcontroller GmbH                     *
// *                        The Embedded Experts                        *
// **********************************************************************
// *                                                                    *
// *            (c) 2014 - 2020 SEGGER Microcontroller GmbH             *
// *            (c) 2001 - 2020 Rowley Associates Limited               *
// *                                                                    *
// *           www.segger.com     Support: support@segger.com           *
// *                                                                    *
// **********************************************************************
// *                                                                    *
// * All rights reserved.                                               *
// *                                                                    *
// * Redistribution and use in source and binary forms, with or         *
// * without modification, are permitted provided that the following    *
// * conditions are met:                                                *
// *                                                                    *
// * - Redistributions of source code must retain the above copyright   *
// *   notice, this list of conditions and the following disclaimer.    *
// *                                                                    *
// * - Neither the name of SEGGER Microcontroller GmbH                  *
// *   nor the names of its contributors may be used to endorse or      *
// *   promote products derived from this software without specific     *
// *   prior written permission.                                        *
// *                                                                    *
// * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
// * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
// * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
// * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
// * DISCLAIMED.                                                        *
// * IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
// * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
// * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
// * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
// * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
// * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
// * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
// * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
// * DAMAGE.                                                            *
// *                                                                    *
// **********************************************************************

.macro ISR_HANDLER name=
  .section .vectors, "ax"
  .word \name
  .section .init, "ax"
  .thumb_func
  .weak \name
\name:
1: b 1b /* endless loop */
.endm

.macro ISR_RESERVED
  .section .vectors, "ax"
  .word 0
.endm

  .syntax unified
  .global reset_handler
  .global Reset_Handler
  .equ Reset_Handler, reset_handler

  .section .vectors, "ax"
  .code 16
  .balign 2
  .global _vectors

.macro DEFAULT_ISR_HANDLER name=
  .thumb_func
  .weak \name
\name:
1: b 1b /* endless loop */
.endm

_vectors:
  .word __stack_end__
  .word reset_handler
ISR_HANDLER NMI_Handler
ISR_HANDLER HardFault_Handler
ISR_HANDLER MemManage_Handler 
ISR_HANDLER BusFault_Handler
ISR_HANDLER UsageFault_Handler
ISR_RESERVED
ISR_RESERVED
ISR_RESERVED
ISR_RESERVED
ISR_HANDLER SVC_Handler
ISR_HANDLER DebugMon_Handler
ISR_RESERVED
ISR_HANDLER PendSV_Handler
ISR_HANDLER SysTick_Handler
#ifdef __VECTORS
#include __VECTORS
#else  
ISR_HANDLER WWDG_IRQHandler                // Window Watchdog
ISR_HANDLER PVD_IRQHandler                 // PVD through EXTI Line detect
ISR_HANDLER RTC_IRQHandler                 // RTC through EXTI Line
ISR_HANDLER FLASH_IRQHandler               // FLASH
ISR_HANDLER RCC_IRQHandler                 // RCC
ISR_HANDLER EXTI0_1_IRQHandler             // EXTI Line 0 and 1
ISR_HANDLER EXTI2_3_IRQHandler             // EXTI Line 2 and 3
ISR_HANDLER EXTI4_15_IRQHandler            // EXTI Line 4 to 15
ISR_HANDLER TS_IRQHandler                  // TS
ISR_HANDLER DMA1_Channel1_IRQHandler       // DMA1 Channel 1
ISR_HANDLER DMA1_Channel2_3_IRQHandler     // DMA1 Channel 2 and Channel 3
ISR_HANDLER DMA1_Channel4_5_IRQHandler     // DMA1 Channel 4 and Channel 5
ISR_HANDLER ADC1_COMP_IRQHandler           // ADC1, COMP1 and COMP2
ISR_HANDLER TIM1_BRK_UP_TRG_COM_IRQHandler // TIM1 Break, Update, Trigger and Commutation
ISR_HANDLER TIM1_CC_IRQHandler             // TIM1 Capture Compare
ISR_HANDLER TIM2_IRQHandler                // TIM2
ISR_HANDLER TIM3_IRQHandler                // TIM3
ISR_HANDLER TIM6_DAC_IRQHandler            // TIM6 and DAC
ISR_HANDLER TIM7_IRQHandler                // Not all devices!!
ISR_HANDLER TIM14_IRQHandler               // TIM14
ISR_HANDLER TIM15_IRQHandler               // TIM15
ISR_HANDLER TIM16_IRQHandler               // TIM16
ISR_HANDLER TIM17_IRQHandler               // TIM17
ISR_HANDLER I2C1_IRQHandler                // I2C1
ISR_HANDLER I2C2_IRQHandler                // I2C2
ISR_HANDLER SPI1_IRQHandler                // SPI1
ISR_HANDLER SPI2_IRQHandler                // SPI2
ISR_HANDLER USART1_IRQHandler              // USART1
ISR_HANDLER USART2_IRQHandler              // USART2
ISR_HANDLER USART3_4_IRQHandler            // Not all devices!!
ISR_HANDLER CEC_IRQHandler                 // CEC
ISR_HANDLER USB_IRQHandler                 // Not all devices!!
#endif
  .section .vectors, "ax"
_vectors_end:

  .section .init, "ax"
  .balign 2

  .thumb_func
  reset_handler:

#ifndef __NO_SYSTEM_INIT
  ldr r0, =__stack_end__
  mov sp, r0
  bl SystemInit
#endif

#if !defined(__SOFTFP__)
  // Enable CP11 and CP10 with CPACR |= (0xf<<20)
  movw r0, 0xED88
  movt r0, 0xE000
  ldr r1, [r0]
  orrs r1, r1, #(0xf << 20)
  str r1, [r0]
#endif

  b _start

#ifndef __NO_SYSTEM_INIT
  .thumb_func
  .weak SystemInit
SystemInit:
  bx lr
#endif
